#include "pch.h"

#include "FTNStruc.hpp"
#include "Common.hpp"
#include "Misc.hpp"
#include "Temp.hpp"
#include "adrenalin.h"
#include "BSO.hpp"


CBSOManager::CBSOManager() {
	int	i, j, k, l;
    
	// prepare BSO directories

	for (i = 0, j = -1, k = -1, l = -1; g_vars.m_szBinkOutboundPath[i] != TEXT('\0'); i++) {
		if (g_vars.m_szBinkOutboundPath[i] == TEXT('\\')) {
			k = j;
			j = i;
		}
		if (g_vars.m_szBinkOutboundPath[i] == TEXT('.'))
		l = i;
	}

	k++;
	lstrcpyn( baseDir, g_vars.m_szBinkOutboundPath, k+1 );
	i = lstrlen( g_vars.m_szBinkOutboundPath );
	if (l < k)
		l = i-1;
	lstrcpyn( defaultDomainDir, g_vars.m_szBinkOutboundPath, l+1 );
	*name  = TEXT('\0');
	nameLen = 0;

	numberOfBaseDirNames = GetNumberOfEnclosedNames(baseDir);
}


CBSOManager::~CBSOManager() {
}


void CBSOManager::setAddress(const SFTNAddress& addr, FlavourType routeType) {
    // check another domain
    if (*addr.Domain != TEXT('\0') && g_vars.m_fCheckDomainInBSO && 
        lstrcmpi( g_vars.m_addrMain.Domain, addr.Domain ) != 0)
    {	    
        wsprintf( name, TEXT("%s%s.%03x\\"), baseDir, addr.Domain, addr.Zone );
    }
    else {
        // check zone
        if (g_vars.m_addrMain.Zone != addr.Zone) {
            wsprintf( name, TEXT("%s.%03x\\"), defaultDomainDir, addr.Zone );
        }
        else
            lstrcpy( name, g_vars.m_szBinkOutboundPath );
    }

    nameLen = lstrlen( name );
    if (addr.Point != 0) {
        wsprintf( name + nameLen, TEXT("%04x%04x.pnt\\"), addr.Net, addr.Node );
        nameLen += 13;
    }

    MakeDirStructure( name, numberOfBaseDirNames );

    if (addr.Point != 0)
        wsprintf( name + nameLen, TEXT("%08x."), addr.Point );
    else
        wsprintf( name + nameLen, TEXT("%04x%04x."), addr.Net, addr.Node );

    nameLen = lstrlen(name);

	wsprintf( name + nameLen, TEXT("%clo"), getRouteChar(routeType) );
}


LPCTSTR	TEMP_BSO_PATH = TEXT("bso.tmp\\");


void CBSOManager::setTempOutboundAddress(const SFTNAddress& addr, FlavourType routeType) {
	LPCTSTR	startupPath = CAdrenalin::getInstance().getStartupPath();

    // check another domain
    if (*addr.Domain != TEXT('\0') && g_vars.m_fCheckDomainInBSO && 
        lstrcmpi( g_vars.m_addrMain.Domain, addr.Domain ) != 0)
    {	    
        wsprintf( name, TEXT("%s%s%s.%03x\\"), startupPath, 
											   TEMP_BSO_PATH,
											   addr.Domain, addr.Zone );
    }
    else {
        // check zone
        if (g_vars.m_addrMain.Zone != addr.Zone) {
            wsprintf( name, TEXT("%s%soutbound.%03x\\"), startupPath, 
														 TEMP_BSO_PATH,
														 addr.Zone );
        }
        else
			wsprintf( name, TEXT("%s%soutbound\\"), startupPath, TEMP_BSO_PATH );
    }

    nameLen = lstrlen( name );
    if (addr.Point != 0) {
        wsprintf( name + nameLen, TEXT("%04x%04x.pnt\\"), addr.Net, addr.Node );
        nameLen += 13;
    }

    MakeDirStructure( name, 0 );

    if (addr.Point != 0)
        wsprintf( name + nameLen, TEXT("%08x."), addr.Point );
    else
        wsprintf( name + nameLen, TEXT("%04x%04x."), addr.Net, addr.Node );

    nameLen = lstrlen(name);

	wsprintf( name + nameLen, TEXT("%clo"), getRouteChar(routeType) );
}


void CBSOManager::getTempEntryPath(tstring& header) {
	TCHAR	buffer[MAX_PATH];
	lstrcpy( buffer, CAdrenalin::getInstance().getStartupPath() );
	lstrcat( buffer, TEMP_BSO_PATH );
	header = buffer;
}


void CBSOManager::collectTempEntries(VTString& entries) {
	TCHAR	findMask[MAX_PATH];
	lstrcpy( findMask, CAdrenalin::getInstance().getStartupPath() );
	lstrcat( findMask, TEMP_BSO_PATH );
	deque<tstring>	pathDeque;
	pathDeque.push_back( findMask );

	// remember first mask length
	int	firstMaskLen = lstrlen( findMask );

	do {
		lstrcpy( findMask, pathDeque.front().c_str() );
		pathDeque.pop_front();
		int	len = lstrlen( findMask );
		lstrcpy( findMask + len, TEXT("*.*") );

		WIN32_FIND_DATA	findData;
		HANDLE			findHandle = FindFirstFile( findMask, &findData );
		if (findHandle != INVALID_HANDLE_VALUE) {
			do {
				// we need only usual files and directories
				if (findData.dwFileAttributes &
					(FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_OFFLINE |
					 FILE_ATTRIBUTE_READONLY | FILE_ATTRIBUTE_TEMPORARY))
				{
					continue;
				}
				if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
					// remember directory if it is not "." or ".."
					if (lstrcmp( findData.cFileName, TEXT(".") ) != 0
						&&
						lstrcmp( findData.cFileName, TEXT("..") ) != 0)
					{
						lstrcpy( findMask + len, findData.cFileName );
						lstrcat( findMask + len, PATH_SEPARATOR_STR );
						pathDeque.push_back( findMask );
					}
				}
				else {
					// remember file
					lstrcpy( findMask + len, findData.cFileName );
					// remember entry without startup path
					entries.push_back( findMask + firstMaskLen );
				}
			} while (FindNextFile( findHandle, &findData ));
			FindClose( findHandle );
		}
	}
	while (!pathDeque.empty());
}


void CBSOManager::getTempEntryName(const SFTNAddress& addr, FlavourType routeType,
								   tstring& entryName) {
	TCHAR	name[MAX_PATH];

    // check another domain
    if (*addr.Domain != TEXT('\0') && g_vars.m_fCheckDomainInBSO && 
        lstrcmpi( g_vars.m_addrMain.Domain, addr.Domain ) != 0)
    {	    
        wsprintf( name, TEXT("%s.%03x\\"), addr.Domain, addr.Zone );
    }
    else {
        // check zone
        if (g_vars.m_addrMain.Zone != addr.Zone) {
            wsprintf( name, TEXT("outbound.%03x\\"), addr.Zone );
        }
        else
			lstrcpy( name, TEXT("outbound\\") );
    }

	int	nameLen = lstrlen( name );
    if (addr.Point != 0) {
        wsprintf( name + nameLen, TEXT("%04x%04x.pnt\\"), addr.Net, addr.Node );
        nameLen += 13;
    }

    if (addr.Point != 0)
        wsprintf( name + nameLen, TEXT("%08x."), addr.Point );
    else
        wsprintf( name + nameLen, TEXT("%04x%04x."), addr.Net, addr.Node );

	nameLen = lstrlen( name );
	name[nameLen++] = getRouteChar( routeType );
	lstrcpy( name + nameLen, TEXT("lo") );
	
	entryName = name;
}


TCHAR CBSOManager::getRouteChar(FlavourType routeType) {
	TCHAR	routeChar;
	switch (routeType) {
	case FT_NORMAL:
		routeChar = TEXT('f');
		break;
	case FT_CRASH:
		routeChar = TEXT('c');
		break;
	case FT_DIRECT:
		routeChar = TEXT('d');
		break;
	case FT_HOLD:
		routeChar = TEXT('h');
		break;
	case FT_IMMEDIATE:
		routeChar = TEXT('i');
		break;
	default:
		// TODO: throw an exception
		routeChar = TEXT('f');
	}
	return routeChar;
}


bool CBSOManager::setBusyFlag() {
	TCHAR	tempFileName[MAX_PATH];
    TCHAR	busyFileName[MAX_PATH];
    HANDLE	busyFile;

    lstrcpy( tempFileName, name );
    lstrcpy( tempFileName + nameLen, TEXT("tmp") );
    busyFile = GetTempFile( tempFileName, GENERIC_WRITE );
    if (busyFile == INVALID_HANDLE_VALUE)
        return false;
    CloseHandle(busyFile);
	lstrcpy( busyFileName, tempFileName );
    lstrcpy( busyFileName + nameLen, TEXT("bsy") );
    if (!MoveFile( tempFileName, busyFileName )) {
        DeleteFile( tempFileName );
        return false;
    }
    return true;
}


bool CBSOManager::clearBusyFlag() {
	TCHAR	busyFileName[MAX_PATH];
	lstrcpy( busyFileName, name );
    lstrcpy( busyFileName + nameLen, TEXT("bsy") );
    return (DeleteFile(busyFileName) == TRUE);
}


bool CBSOManager::isBusyFlagExist() {
	TCHAR	busyFileName[MAX_PATH];

	lstrcpy( busyFileName, name );
	lstrcpy( busyFileName + nameLen, TEXT("bsy") );

	HANDLE	busyFile = CreateFile( busyFileName, 
								   GENERIC_READ,
								   FILE_SHARE_DELETE | FILE_SHARE_READ | FILE_SHARE_WRITE,
								   NULL,
								   OPEN_EXISTING,
								   FILE_ATTRIBUTE_HIDDEN,
								   NULL );

	if (busyFile != INVALID_HANDLE_VALUE) {
		// opened successfully
		CloseHandle(busyFile);
		return true;
	}
	// error occured while opening file, lets check it
	// possibly we cannot share file but it exists
	return (GetLastError() == ERROR_SHARING_VIOLATION);
}
